/*
 * Decompiled with CFR 0.152.
 */
package com.molekul.setup.elementsetup;

import com.molekul.setup.elementsetup.WinRegistry;
import com.molekul.setup.elementsetup.WindowsReqistry;
import com.sun.management.OperatingSystemMXBean;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SistemGereksinim {
    private static final Map<String, String> sqlversionmap;
    private static int winkey;

    SistemGereksinim() {
    }

    static String getOrtamBilesenleri() {
        StringBuilder envlist = new StringBuilder();
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if (entry.getKey().equals("Path")) {
                envlist.append(entry.getKey()).append(" = ").append("\n");
                String path = entry.getValue();
                for (String s : path.split(";")) {
                    envlist.append("\t\t - ").append(s).append("\n");
                }
                continue;
            }
            envlist.append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
        }
        return envlist.toString();
    }

    static String getDonanimBilgileri() {
        StringBuilder donanim = new StringBuilder();
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long memorySize = operatingSystemMXBean.getTotalPhysicalMemorySize();
        donanim.append("[RAM]\nInfo=").append(SistemGereksinim.getBoyutFormat(memorySize)).append("\n\n");
        try {
            String processorNameString = WinRegistry.readString(-2147483646, "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0", "ProcessorNameString", winkey);
            donanim.append("[CPU]\nInfo=").append(processorNameString).append("\n\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File[] roots = File.listRoots();
        int j = 1;
        for (int i = 0; i < roots.length; ++i) {
            File root = roots[i];
            if (root.getTotalSpace() == 0L) continue;
            donanim.append("[DISK").append(j++).append("]\n").append("Name=").append(root.getAbsolutePath(), 0, 1).append("\n").append("T=").append(SistemGereksinim.getBoyutFormat(root.getTotalSpace())).append("\n").append("F=").append(SistemGereksinim.getBoyutFormat(root.getFreeSpace())).append("\n\n");
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        donanim.append("[EKRAN]\nInfo=").append((int)screenSize.getWidth()).append("x").append((int)screenSize.getHeight()).append("\n\n");
        return donanim.toString();
    }

    static String getYazilimBilgileri() {
        String realArch;
        StringBuilder yazilim = new StringBuilder();
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        String string = realArch = arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "64-bit" : "32-bit";
        if (realArch.equals("32-bit")) {
            winkey = 512;
        }
        String osarch = System.getProperty("os.arch");
        System.out.println("OS Arch:" + osarch + " - " + realArch);
        yazilim.append("[OS]\nInfo=").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append("\n").append("Type=").append(realArch).append("\n\n");
        yazilim.append("[JAVA]\nInfo=").append(System.getProperty("java.version")).append("\n\n");
        SistemGereksinim.sqlinfo(yazilim);
        SistemGereksinim.frameworkinfo(yazilim);
        SistemGereksinim.windowsinstallerinfo(yazilim);
        SistemGereksinim.akisinfo(yazilim);
        SistemGereksinim.arksignerinfo(yazilim);
        return yazilim.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sqlinfo(StringBuilder sb) {
        try {
            sb.append("[SQL]\n");
            Object[] instances = WindowsReqistry.readSqlInstances();
            if (instances.length == 0) {
                try {
                    String[] baseKeys;
                    ArrayList<String> instancelist = new ArrayList<String>();
                    for (String baseKey : baseKeys = new String[]{"SOFTWARE\\Microsoft\\Microsoft SQL Server", "SOFTWARE\\WOW6432Node\\Microsoft\\Microsoft SQL Server"}) {
                        try {
                            List<String> subkeys = WinRegistry.readStringSubKeys(-2147483646, baseKey + "\\", winkey);
                            for (String subkey : subkeys) {
                                if (!subkey.startsWith("MSSQL") || !subkey.contains(".")) continue;
                                instancelist.add(subkey);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    instances = instancelist.toArray(new String[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Bulunan \u00f6rnekler: " + Arrays.toString(instances));
            for (int i = 0; i < instances.length; ++i) {
                Object instance = instances[i];
                String version = null;
                try {
                    version = WinRegistry.readString(-2147483646, "SOFTWARE\\Microsoft\\Microsoft SQL Server\\" + (String)instance + "\\MSSQLServer\\CurrentVersion", "CurrentVersion", winkey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (version == null) {
                    try {
                        version = WinRegistry.readString(-2147483646, "SOFTWARE\\Microsoft\\Microsoft SQL Server\\" + (String)instance + "\\CurrentVersion", "CurrentVersion", winkey);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (version == null) {
                    try {
                        version = WinRegistry.readString(-2147483646, "SOFTWARE\\WOW6432Node\\Microsoft\\Microsoft SQL Server\\" + (String)instance + "\\MSSQLServer\\CurrentVersion", "CurrentVersion", winkey);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (version == null) {
                    try {
                        version = WinRegistry.readString(-2147483646, "SOFTWARE\\Microsoft\\Microsoft SQL Server\\" + (String)instance + "\\Setup\\Version", "Version", winkey);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String versionName = "Unknown";
                if (version != null) {
                    String major = version.split("\\.")[0];
                    versionName = sqlversionmap.containsKey(major) ? sqlversionmap.get(major) : "Unknown";
                }
                sb.append("INSTANCE").append(i + 1).append("=").append((String)instance).append("\n").append("VERSION").append(i + 1).append("=").append(version).append("\n").append("VERSIONNAME").append(i + 1).append("=").append(versionName).append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sb.append("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sqlinfo2014(StringBuilder sb) {
        try {
            sb.append("[SQL]\n");
            Object[] instances = WindowsReqistry.readSqlInstances();
            if (instances.length == 0) {
                try {
                    ArrayList<String> instancelist = new ArrayList<String>();
                    String installedInstances = WinRegistry.readString(-2147483646, "SOFTWARE\\Microsoft\\Microsoft SQL Server", "InstalledInstances", winkey);
                    List<String> subkeys = WinRegistry.readStringSubKeys(-2147483646, "SOFTWARE\\Microsoft\\Microsoft SQL Server\\", winkey);
                    for (String subkey : subkeys) {
                        if (!subkey.startsWith("MSSQL") || !subkey.contains(".")) continue;
                        System.out.println(subkey);
                        instancelist.add(subkey);
                    }
                    instances = (String[])instancelist.toArray(instances);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println(Arrays.toString(instances));
            for (int i = 0; i < instances.length; ++i) {
                Object instance = instances[i];
                String version = WinRegistry.readString(-2147483646, "SOFTWARE\\Microsoft\\Microsoft SQL Server\\" + (String)instance + "\\MSSQLServer\\CurrentVersion", "CurrentVersion", winkey);
                String versionname = sqlversionmap.get(version.substring(0, version.indexOf(".")));
                sb.append("INSTANCE").append(i + 1).append("=").append((String)instance).append("\n").append("VERSION").append(i + 1).append("=").append(version).append("\n").append("VERSIONNAME").append(i + 1).append("=").append(versionname).append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sb.append("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void windowsinstallerinfo(StringBuilder sb) {
        block13: {
            try {
                sb.append("[WINDOWSINSTALLER]\n");
                String dllFileName = System.getenv("WINDIR") + "\\system32\\msi.dll";
                File script = File.createTempFile("xxxxx", ".vbs");
                File result = File.createTempFile("xxxxx", ".txt");
                try {
                    FileWriter fwrt = new FileWriter(script);
                    fwrt.append("Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\r\n").append("Wscript.Echo objFSO.GetFileVersion(\"").append(dllFileName).append("\")");
                    fwrt.close();
                    Process p = Runtime.getRuntime().exec("cmd.exe /c cscript " + script.getAbsolutePath() + " >" + result.getAbsolutePath());
                    int ret = p.waitFor();
                    if (ret != 0) {
                        System.out.println("Error :(  Exit code = " + ret);
                        break block13;
                    }
                    try (BufferedReader rd = null;){
                        String s;
                        rd = new BufferedReader(new FileReader(result));
                        while (null != (s = rd.readLine())) {
                            if (!s.matches("^[\\d\\.]+$")) continue;
                            System.out.println("DLL version of " + dllFileName + " is: " + s);
                            sb.append("Info=").append(s).append("\n");
                            break;
                        }
                    }
                }
                finally {
                    script.delete();
                    result.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                sb.append("\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void frameworkinfo(StringBuilder sb) {
        try {
            sb.append("[NETFR]\n");
            List<String> versions = WinRegistry.readStringSubKeys(-2147483646, "SOFTWARE\\Microsoft\\NET Framework Setup\\NDP", winkey);
            double max = 0.0;
            String maxvers = "";
            for (String version : versions) {
                if (!version.startsWith("v")) continue;
                try {
                    double v = Double.parseDouble(version.substring(version.indexOf("v") + 1));
                    if (!(v > max)) continue;
                    max = v;
                    maxvers = version;
                }
                catch (Exception exception) {}
            }
            String v = WinRegistry.readString(-2147483646, "SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\" + maxvers + "\\Full", "Version", winkey);
            if (v != null) {
                sb.append("Info=").append(v).append("\n");
            } else {
                v = WinRegistry.readString(-2147483646, "SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\" + maxvers + ".0\\Full", "Version", winkey);
                if (v != null) {
                    sb.append("Info=").append(v).append("\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sb.append("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void arksignerinfo(StringBuilder sb) {
        try {
            String osname = System.getProperty("os.name");
            String userhome = System.getProperty("user.home");
            sb.append("[ARKSIGNER]\nInfo=");
            String appdataprograms = userhome + (osname.toLowerCase().contains("xp") ? "\\Local Settings\\Application Data\\Programs" : "\\AppData\\Local\\Programs");
            File programsdir = new File(appdataprograms);
            for (File file : programsdir.listFiles()) {
                if (!file.getName().equals("Ark")) continue;
                sb.append("1");
                return;
            }
            sb.append("0");
        }
        catch (Exception e) {
            sb.append("0");
        }
        finally {
            sb.append("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void akisinfo(StringBuilder sb) {
        block8: {
            try {
                sb.append("[AKIS]\nInfo=");
                try {
                    String arch = System.getenv("PROCESSOR_ARCHITECTURE");
                    String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
                    String realArch = arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "64-bit" : "32-bit";
                    String filePath = "";
                    filePath = realArch.equals("64-bit") ? "C:\\Program Files\\Akia\\Akia.exe" : "C:\\Program Files (x86)\\Akia\\Akia.exe";
                    File file = new File(filePath);
                    if (file.exists() && file.isFile()) {
                        sb.append("1");
                        break block8;
                    }
                    sb.append("0");
                }
                catch (Exception e) {
                    sb.append("0");
                }
            }
            catch (Exception e) {
                sb.append("0");
            }
            finally {
                sb.append("\n\n");
            }
        }
    }

    private static String getBoyutFormat(long byteboyut) {
        double b = byteboyut;
        String boyutFormat = b > 1024.0 ? ((b /= 1024.0) > 1024.0 ? ((b /= 1024.0) > 1024.0 ? String.format("%.2f GB", b /= 1024.0) : String.format("%.2f MB", b)) : String.format("%.2f KB", b)) : String.format("%.2f Byte", b);
        return boyutFormat;
    }

    static {
        winkey = 256;
        sqlversionmap = new HashMap<String, String>();
        sqlversionmap.put("8", "SQL Server 2000");
        sqlversionmap.put("9", "SQL Server 2005");
        sqlversionmap.put("10", "SQL Server 2008");
        sqlversionmap.put("11", "SQL Server 2012");
        sqlversionmap.put("12", "SQL Server 2014");
        sqlversionmap.put("13", "SQL Server 2016");
        sqlversionmap.put("14", "SQL Server 2017");
        sqlversionmap.put("15", "SQL Server 2019");
        sqlversionmap.put("16", "SQL Server 2022");
    }
}

