/*
 * Decompiled with CFR 0.152.
 */
package com.molekul.setup.elementsetup;

import com.molekul.setup.elementsetup.Download;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Observable;
import java.util.Observer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class Setup {
    static String arch = "32-bit";
    static String title = "";
    static String elementpath = "";

    static String setup(String program) throws Exception {
        block25: {
            try {
                Profile.Section systemIniOs = (Profile.Section)new Ini(ClassLoader.getSystemResourceAsStream("system.ini")).get("OS");
                if (((String)systemIniOs.get("Type")).contains("64")) {
                    arch = "64-bit";
                }
            }
            catch (Exception systemIniOs) {
                // empty catch block
            }
            Profile.Section section = (Profile.Section)new Ini(ClassLoader.getSystemResourceAsStream("config.ini")).get(program);
            String path = program.equals("sqlserver") || program.equals("sqlmanagement") ? (String)section.get("path") : (program.equals("akis") ? (arch.equals("64-bit") ? (String)section.get("path64") : (String)section.get("path32")) : (String)section.get("path"));
            Download download = new Download(new URL(path), "./setup/" + program);
            while (download.getStatus() == 0) {
                Thread.sleep(10L);
            }
            if (download.getStatus() == 4) {
                return "Dosya indirilirken hata olu\u015ftu. " + download.getErrormessage();
            }
            try {
                String fileName = download.getFileName();
                if (fileName.contains(".exe")) {
                    String line;
                    Process p = Runtime.getRuntime().exec(".\\" + fileName);
                    BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    while ((line = input.readLine()) != null) {
                        System.out.println(line);
                    }
                    input.close();
                    break block25;
                }
                if (!fileName.contains(".zip")) break block25;
                UnZip unzip = new UnZip(fileName, program.contains("element") && !program.contains("hastakabul") ? elementpath : "setup/" + program);
                while (unzip.getStatus() == 0) {
                    Thread.sleep(10L);
                }
                if (unzip.getStatus() == 2) {
                    return "\u0130ndirilen dosya Zip'ten \u00e7\u0131kar\u0131l\u0131rken hata olu\u015ftu. " + unzip.getErrormessage();
                }
                if (program.contains("element") && !program.contains("hastakabul")) break block25;
                StringBuilder setupsb = new StringBuilder();
                setupsb.append("cmd /c start /wait ./setup/").append(program).append("/");
                if (program.equals("sqlserver")) {
                    setupsb.append(Setup.getSqlBatStr());
                } else if (program.equals("sqlmanagement")) {
                    setupsb.append(Setup.getSqlManagementBatStr());
                } else {
                    String exe = Setup.findSetupFile(new File("setup/" + program), program.equals("akis") && arch.equals("32-bit") ? ".msi" : ".exe");
                    if (program.equals("arksigner")) {
                        setupsb.append(exe).append(" /SILENT");
                    } else if (program.equals("windowsinstaller") || program.equals("akis")) {
                        setupsb.append(exe).append(" /passive");
                    } else {
                        setupsb.append(exe);
                    }
                }
                Process p = Runtime.getRuntime().exec(setupsb.toString());
                try {
                    p.waitFor();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (program.equals("sqlserver")) {
                    try {
                        Process sqlbrowseraccount = Runtime.getRuntime().exec("sc.exe config \"SQLBrowser\" obj=\"NT AUTHORITY\\NETWORKSERVICE\"");
                        sqlbrowseraccount.waitFor();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (program.equals("sqlserver") || program.equals("sqlmanagement")) {
                    return Setup.sqlAfterLog();
                }
            }
            catch (Exception err) {
                err.printStackTrace();
                return err instanceof NullPointerException ? "" : err.getMessage();
            }
        }
        return "";
    }

    private static String getSqlBatStr2014() {
        return "SETUP.EXE /IACCEPTSQLSERVERLICENSETERMS /ACTION=Install /INSTANCEID=\"SQLEXPRESS\" /INSTANCENAME=\"SQLEXPRESS\" /SECURITYMODE=\"SQL\" /SAPWD=\"A123456a\" /TCPENABLED=1 /NPENABLED=1 /SQLSVCSTARTUPTYPE=\"Automatic\" /BROWSERSVCSTARTUPTYPE=\"Automatic\" /SQLSVCACCOUNT=\"NT AUTHORITY\\SYSTEM\" /SQLCOLLATION=\"Turkish_CI_AS\" /ASCOLLATION=\"Turkish_CI_AS\" /QUIETSIMPLE=1 /HIDECONSOLE";
    }

    private static String getSqlBatStr() {
        String extractDir = ".\\setup\\sqlserver\\SQLEXPR_x64_ENU";
        return "SQLEXPR_x64_ENU.exe /q /x:" + extractDir + " && " + extractDir + "\\SETUP.EXE /IACCEPTSQLSERVERLICENSETERMS /ACTION=Install /INSTANCEID=\"SQLEXPRESS\" /INSTANCENAME=\"SQLEXPRESS\" /SECURITYMODE=SQL /SAPWD=\"A123456a\" /TCPENABLED=1 /NPENABLED=1 /SQLSVCSTARTUPTYPE=\"Automatic\" /BROWSERSVCSTARTUPTYPE=\"Automatic\" /SQLSVCACCOUNT=\"NT AUTHORITY\\SYSTEM\" /SQLCOLLATION=\"Turkish_CI_AS\" /ASCOLLATION=\"Turkish_CI_AS\" /QUIETSIMPLE=1 /HIDECONSOLE";
    }

    private static String getSqlManagementBatStr2014() {
        return "SETUP.EXE /IACCEPTSQLSERVERLICENSETERMS /ACTION=INSTALL /QUIETSIMPLE /FEATURES=SSMS /HIDECONSOLE";
    }

    private static String getSqlManagementBatStr() {
        return "SSMS-Setup-ENU.exe /install /quiet /norestart /log ssms_install.log";
    }

    private static String findSetupFile(File dir, String suffix) {
        File[] files = dir.listFiles(new SuffixFileFilter(suffix));
        if (files != null) {
            return "\"" + files[0].getName() + "\"";
        }
        return null;
    }

    private static String sqlAfterLog() {
        try {
            String[] programDirs;
            for (String string : programDirs = new String[]{System.getenv("ProgramFiles") + "\\Microsoft SQL Server", System.getenv("ProgramFiles(x86)") + "\\Microsoft SQL Server", System.getenv("ProgramData") + "\\Microsoft\\SQLServer"}) {
                File[] versionDirs;
                File baseDir = new File(string);
                if (!baseDir.exists() || (versionDirs = baseDir.listFiles(File::isDirectory)) == null) continue;
                for (File versionDir : versionDirs) {
                    File summaryFile = new File(versionDir, "Setup Bootstrap\\Log\\Summary.txt");
                    if (!summaryFile.exists()) continue;
                    String result = Setup.parseLogFile(summaryFile);
                    if (!result.isEmpty()) {
                        return result;
                    }
                    return "";
                }
            }
            File exeDir = new File(System.getProperty("user.dir"));
            File[] ssmsLogs = exeDir.listFiles((d, name) -> name.toLowerCase().startsWith("ssms_install") && name.toLowerCase().endsWith(".log"));
            if (ssmsLogs != null && ssmsLogs.length > 0) {
                File ssmsLog = ssmsLogs[0];
                for (File f : ssmsLogs) {
                    if (f.lastModified() <= ssmsLog.lastModified()) continue;
                    ssmsLog = f;
                }
                String string = Setup.parseLogFile(ssmsLog);
                if (!string.isEmpty()) {
                    return string;
                }
                return "";
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String parseLogFile(File logFile) throws IOException {
        long lastCode = -1L;
        try (BufferedReader reader = new BufferedReader(new FileReader(logFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                int index;
                String lowerLine = line.toLowerCase();
                if (!lowerLine.contains("exit code") && !lowerLine.contains("error code") || (index = line.indexOf(58)) == -1 || index >= line.length() - 1) continue;
                String codeStr = line.substring(index + 1).trim();
                lastCode = Setup.parseExitCode(codeStr);
            }
        }
        return Setup.formatExitCodeResult(lastCode);
    }

    private static long parseExitCode(String codeStr) {
        codeStr = codeStr.trim().toLowerCase();
        try {
            if (codeStr.startsWith("0x")) {
                return Long.parseUnsignedLong(codeStr.substring(2), 16);
            }
            return Long.parseLong(codeStr);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static String formatExitCodeResult(long code) {
        if (code == 0L || code == 3010L || code == 1602L || code == -1L) {
            return "";
        }
        return "Exit code: " + code;
    }

    static class UnZipTrack
    implements Observer {
        final JProgressBar j;
        final JDialog dlg;
        JLabel prgrslabl = new JLabel("Ba\u015flat\u0131l\u0131yor...");

        UnZipTrack(int downloadsize) {
            this.j = new JProgressBar(0, downloadsize);
            this.dlg = new JDialog((Frame)null, title + " paketten \u00e7\u0131kar\u0131l\u0131yor...");
            try {
                InputStream is = ClassLoader.getSystemResourceAsStream("zip.png");
                BufferedImage image = ImageIO.read(is);
                this.dlg.setIconImage(image);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.dlg.add("Center", this.j);
            this.dlg.add("North", this.prgrslabl);
            this.dlg.setDefaultCloseOperation(0);
            this.dlg.setSize(300, 75);
            this.dlg.setLocationRelativeTo(null);
            this.dlg.setAlwaysOnTop(true);
            this.dlg.setVisible(true);
        }

        @Override
        public void update(Observable o, Object arg) {
            UnZip unzip = (UnZip)o;
            if (unzip.getStatus() == 2) {
                JOptionPane.showMessageDialog(this.dlg, "Paketten \u00c7\u0131kar\u0131l\u0131rken Hata!");
            } else if (unzip.getStatus() == 1) {
                this.dlg.dispose();
            } else {
                try {
                    this.j.setValue(unzip.getUnzipped());
                    double prg = (double)unzip.getUnzipped() / (double)unzip.getSize() * 100.0;
                    if (prg > 100.0) {
                        prg = 100.0;
                    }
                    this.prgrslabl.setText("%" + String.format("%.2f", prg));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static class UnZip
    extends Observable
    implements Runnable {
        final String zipFilePath;
        final String destDir;
        static final String[] STATUSES = new String[]{"\u00c7\u0131kar\u0131l\u0131yor", "Tamamland\u0131", "Hata"};
        static final int UNZIPPING = 0;
        static final int COMPLETED = 1;
        static final int ERROR = 2;
        private int status;
        private int unzipped;
        private int size;
        private String errormessage = "";

        public UnZip(String zipFilePath, String destDir) {
            this.zipFilePath = zipFilePath;
            this.destDir = destDir;
            this.size = -1;
            this.unzipped = 0;
            this.unzip();
        }

        private void unzip() {
            Thread thread = new Thread(this);
            thread.start();
            this.status = 0;
        }

        @Override
        public void run() {
            try {
                ZipInputStream zis;
                File dir = new File(this.destDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                FileInputStream fis = new FileInputStream(this.zipFilePath);
                if (this.size == -1) {
                    zis = new ZipInputStream((InputStream)fis, Charset.forName("CP857"));
                    ZipEntry entry = zis.getNextEntry();
                    while (entry != null) {
                        this.size = (int)((long)this.size + entry.getSize());
                        zis.closeEntry();
                        entry = zis.getNextEntry();
                    }
                    zis.closeEntry();
                    zis.close();
                    this.addObserver(new UnZipTrack(this.size));
                    this.stateChanged();
                }
                fis = new FileInputStream(this.zipFilePath);
                zis = new ZipInputStream((InputStream)fis, Charset.forName("CP857"));
                byte[] buffer = new byte[1024];
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    String fileName = ze.getName();
                    if (fileName.lastIndexOf("/") != fileName.length() - 1) {
                        int len;
                        File newFile = new File(this.destDir + File.separator + fileName);
                        System.out.println("Unzipping to " + newFile.getAbsolutePath());
                        new File(newFile.getParent()).mkdirs();
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                            this.unzipped += len;
                            this.stateChanged();
                        }
                        fos.close();
                    } else {
                        new File(this.destDir + File.separator + fileName).mkdirs();
                    }
                    zis.closeEntry();
                    ze = zis.getNextEntry();
                }
                zis.closeEntry();
                this.status = 1;
                try {
                    zis.close();
                    fis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.stateChanged();
            }
            catch (Exception e) {
                this.error(e);
            }
        }

        private void stateChanged() {
            this.setChanged();
            this.notifyObservers();
        }

        private void error(Exception e) {
            this.status = 2;
            e.printStackTrace();
            this.errormessage = e.getMessage();
            this.stateChanged();
        }

        public int getStatus() {
            return this.status;
        }

        public int getUnzipped() {
            return this.unzipped;
        }

        public String getErrormessage() {
            return this.errormessage;
        }

        public int getSize() {
            return this.size;
        }
    }
}

