/*
 * Decompiled with CFR 0.152.
 */
package com.molekul.setup.elementsetup;

import com.molekul.setup.elementsetup.Setup;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

class Download
extends Observable
implements Runnable {
    private static final int MAX_BUFFER_SIZE = 1024;
    public static final String[] STATUSES = new String[]{"Downloading", "Paused", "Complete", "Cancelled", "Error"};
    public static final int DOWNLOADING = 0;
    public static final int PAUSED = 1;
    public static final int COMPLETE = 2;
    public static final int CANCELLED = 3;
    public static final int ERROR = 4;
    private URL url;
    private String destdir;
    private long size;
    private long downloaded;
    private int status;
    private String fileName;
    private String errormessage = "";

    public Download(URL url, String destdir) {
        this.url = url;
        this.destdir = destdir;
        this.size = -1L;
        this.downloaded = 0L;
        this.download();
    }

    public String getUrl() {
        return this.url.toString();
    }

    public long getSize() {
        return this.size;
    }

    public float getProgress() {
        return (float)this.downloaded / (float)this.size * 100.0f;
    }

    public int getStatus() {
        return this.status;
    }

    public void pause() {
        this.status = 1;
        this.stateChanged();
    }

    public void resume() {
        this.download();
        this.stateChanged();
    }

    public void cancel() {
        this.status = 3;
        this.stateChanged();
    }

    private void error(String errormessage) {
        this.errormessage = errormessage;
        this.status = 4;
        this.stateChanged();
    }

    private void download() {
        Thread thread = new Thread(this);
        thread.start();
        this.status = 0;
    }

    public String getFileName() {
        if (this.fileName == null) {
            String f = this.url.getFile();
            File dir = new File(this.destdir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.fileName = this.destdir + "/" + f.substring(f.lastIndexOf(47) + 1);
        }
        return this.fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block31: {
            RandomAccessFile file = null;
            InputStream stream = null;
            try {
                byte[] buffer;
                int read;
                int contentLength;
                file = new RandomAccessFile(this.getFileName(), "rw");
                HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
                connection.connect();
                if (file.length() == (long)connection.getContentLength()) {
                    this.status = 2;
                    this.stateChanged();
                    return;
                }
                file.seek(file.length());
                connection = (HttpURLConnection)this.url.openConnection();
                connection.setRequestProperty("Range", "bytes=" + file.length() + "-");
                connection.setReadTimeout(600000);
                connection.connect();
                if (connection.getResponseCode() / 100 != 2 && connection.getResponseCode() != 416) {
                    this.error("HTTP Response: " + connection.getResponseCode());
                }
                if ((contentLength = connection.getContentLength()) < 1) {
                    this.error("Dosya bulunamad\u0131!");
                }
                if (this.size == -1L) {
                    this.size = contentLength;
                    this.addObserver(new DownloadTrack(0, (int)this.size));
                    this.stateChanged();
                }
                stream = connection.getInputStream();
                while (this.status == 0 && (read = stream.read(buffer = this.size - this.downloaded > 1024L ? new byte[1024] : new byte[(int)(this.size - this.downloaded)])) != -1 && read != 0) {
                    file.write(buffer, 0, read);
                    this.downloaded += (long)read;
                    this.stateChanged();
                }
                if (this.status != 0) break block31;
                this.status = 2;
                try {
                    file.close();
                    stream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.stateChanged();
            }
            catch (Exception e) {
                this.error(e.getMessage());
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void stateChanged() {
        this.setChanged();
        this.notifyObservers();
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public String getErrormessage() {
        return this.errormessage;
    }

    static class DownloadTrack
    implements Observer {
        final JProgressBar j;
        final JDialog dlg;
        JLabel prgrslabl = new JLabel("Ba\u015flat\u0131l\u0131yor...");

        public DownloadTrack(int downloadsize, int size) {
            this.j = new JProgressBar(downloadsize, size);
            this.dlg = new JDialog((Frame)null, Setup.title + " \u0130ndiriliyor...");
            try {
                InputStream is = ClassLoader.getSystemResourceAsStream("download.png");
                BufferedImage image = ImageIO.read(is);
                this.dlg.setIconImage(image);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.dlg.add("Center", this.j);
            this.dlg.add("North", this.prgrslabl);
            this.dlg.setDefaultCloseOperation(0);
            this.dlg.setSize(300, 75);
            this.dlg.setLocationRelativeTo(null);
            this.dlg.setAlwaysOnTop(true);
            this.dlg.setVisible(true);
        }

        @Override
        public void update(Observable o, Object arg) {
            Download download = (Download)o;
            if (download.getStatus() == 4) {
                JOptionPane.showMessageDialog(this.dlg, "\u0130ndirirken Hata!");
            } else if (download.getStatus() == 2) {
                this.dlg.dispose();
            } else {
                try {
                    this.j.setValue((int)download.getDownloaded());
                    double prg = (double)download.getDownloaded() / (double)download.getSize() * 100.0;
                    this.prgrslabl.setText("%" + String.format("%.2f", prg));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

